/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.v4;

import com.creamtec.ajaxswing.core.ActionData;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.HttpRequestData;
import com.creamtec.ajaxswing.core.NativeEmulator;
import com.creamtec.ajaxswing.v4.render.ComponentUpdater;
import com.creamtec.ajaxswing.v4.render.DefaultComponentProcessor;
import com.creamtec.core.TraceMgr;
import java.awt.Component;
import java.awt.Point;
import java.net.URLDecoder;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;

public class AjaxSwingV4Updater {
    public boolean updateComponent(HttpRequestData data, ActionData action) throws Exception {
        ComponentUpdater updater;
        Point point;
        int modifiers;
        Component comp = action.getComponent();
        ClientAgent agent = action.getAgent();
        if ("mouseEnter".equals(action.getEventType())) {
            NativeEmulator.emulateMouseEnter((Component)comp, (Point)this.getEventPoint(action.getParams()[0]));
        }
        if ("click".equals(action.getEventType())) {
            modifiers = this.getEventModifiers(action.getModifiers());
            point = this.getEventPoint(action.getParams()[0]);
            NativeEmulator.mouseLeftClick((Component)comp, (Point)point, (int)1, (int)modifiers);
        }
        if ("click2".equals(action.getEventType())) {
            modifiers = this.getEventModifiers(action.getModifiers());
            point = this.getEventPoint(action.getParams()[0]);
            NativeEmulator.mouseLeftClick((Component)comp, (Point)point, (int)2, (int)modifiers);
        }
        if ("context".equals(action.getEventType())) {
            modifiers = this.getEventModifiers(action.getModifiers());
            point = this.getEventPoint(action.getParams()[0]);
            NativeEmulator.mouseRightClick((Component)comp, (Point)point, (int)modifiers);
        }
        if ("mousewheel".equals(action.getEventType())) {
            modifiers = this.getEventModifiers(action.getModifiers());
            point = this.getEventPoint(action.getParams()[0]);
            int wheelValue = Integer.parseInt(action.getModifiers().substring(action.getModifiers().lastIndexOf(126) + 1));
            NativeEmulator.mouseWheel((Component)comp, (Point)point, (int)wheelValue, (int)modifiers);
        }
        if ("dragXY".equals(action.getEventType())) {
            String[] params = action.getParams()[0].split("_");
            Point startPoint = new Point(Integer.valueOf(params[0]), Integer.valueOf(params[1]));
            Point targetPoint = new Point(Integer.valueOf(params[2]), Integer.valueOf(params[3]));
            NativeEmulator.mouseDragAndDrop((Component)comp, (Component)comp, (Point)startPoint, (Point)targetPoint, (int)0);
        }
        if ("scroll".equals(action.getEventType())) {
            Point point2 = this.getEventPoint(action.getParams()[0]);
            if (comp instanceof JScrollPane) {
                JScrollPane pane = (JScrollPane)comp;
                if (pane.getHorizontalScrollBar() != null) {
                    pane.getHorizontalScrollBar().setValue(point2.x);
                }
                if (pane.getVerticalScrollBar() != null) {
                    pane.getVerticalScrollBar().setValue(point2.y);
                }
            }
        }
        if ("keydown".equals(action.getEventType()) && comp != null) {
            String[] params = action.getParams()[0].split("_");
            int modifiers2 = this.getEventModifiers(params[0]);
            int keyCode = Integer.valueOf(params[1]);
            int n = keyCode = keyCode == 13 ? 10 : keyCode;
            if (comp instanceof JTextComponent) {
                NativeEmulator.emulateFocus((Component)comp);
                if ((comp instanceof JTextArea || comp instanceof JEditorPane) && keyCode == 9) {
                    modifiers2 = modifiers2 | 0x80 | 2;
                }
            }
            int location = Integer.valueOf(params[2]);
            char keyChar = (char)keyCode;
            if (params.length > 3) {
                keyChar = URLDecoder.decode(params[3], "UTF-8").charAt(0);
            } else if (action.getActionString().endsWith("__")) {
                keyChar = '_';
            }
            NativeEmulator.keypress((Component)comp, (int)modifiers2, (int)keyCode, (char)keyChar, (int)location);
        }
        if ("type".equals(action.getEventType())) {
            String newText;
            String text = action.getParamsStr();
            JTextComponent textComponent = (JTextComponent)comp;
            String oldText = this.getTextSafe(textComponent);
            textComponent.putClientProperty("ajaxswing.oldText", oldText);
            boolean agentPropsValue = agent.getProps().getBooleanProperty("agent.emulateKeyType", true);
            String componentProp = agent.getComponentProperty((Object)comp, "emulateKeyType");
            boolean isCompPropSet = componentProp != null;
            boolean compPropVal = "true".equals(componentProp);
            boolean compEmulateLimited = "true".equalsIgnoreCase(agent.getComponentProperty((Object)comp, "emulateKeyTypeLimited"));
            if (isCompPropSet && compPropVal && !compEmulateLimited || !isCompPropSet && !compEmulateLimited && agentPropsValue) {
                if (StringUtils.isEmpty((CharSequence)text)) {
                    this.setCaretToZeroPosition(textComponent);
                }
                NativeEmulator.typeText((Component)comp, (String)text, (String)oldText);
            }
            if (!text.equals(newText = this.getTextSafe(textComponent))) {
                String componentPropPreventSetText;
                boolean allowToUseSetText;
                if (text.length() > 0) {
                    if (compEmulateLimited) {
                        NativeEmulator.typeText((Component)comp, (String)text.substring(0, 1), (String)"");
                    }
                } else {
                    this.setCaretToZeroPosition(textComponent);
                    NativeEmulator.keypress((Component)comp, (int)0, (int)127);
                }
                boolean bl = allowToUseSetText = (componentPropPreventSetText = agent.getComponentProperty((Object)comp, "preventSetTextForType")) == null || "false".equals(componentPropPreventSetText);
                if (allowToUseSetText) {
                    textComponent.setText(text);
                }
                if (!text.equals(newText = this.getTextSafe(textComponent))) {
                    textComponent.putClientProperty("ajaxswing.oldText", text);
                }
            }
        }
        if ("resize".equals(action.getEventType())) {
            Point point3 = this.getEventPoint(action.getParams()[0]);
            agent.setClientSize(point3.x, point3.y);
            agent.getUIManager().resizeWindows();
        }
        if ("caret".equals(action.getEventType())) {
            try {
                ((JTextComponent)comp).setCaretPosition(Integer.parseInt(action.getParams()[0]));
            }
            catch (Exception ex) {
                TraceMgr.trace((Object)ex, (String)"Failed to set caret position");
            }
        }
        if ((updater = agent.getWindowUpdater().getComponentUpdater(comp.getClass())) != null && !(updater instanceof DefaultComponentProcessor)) {
            updater.updateComponent(action, data);
        }
        return true;
    }

    private void setCaretToZeroPosition(JTextComponent textComponent) {
        Caret c = textComponent.getCaret();
        if (c != null) {
            c.setDot(0);
        }
    }

    private int getEventModifiers(String modifiersString) {
        int modifiers = 0;
        if (modifiersString.contains("s")) {
            modifiers = modifiers | 0x40 | 1;
        }
        if (modifiersString.contains("ac")) {
            modifiers = modifiers | 0x2000 | 0x20;
        } else {
            if (modifiersString.contains("c")) {
                modifiers = modifiers | 0x80 | 2;
            }
            if (modifiersString.contains("a")) {
                modifiers = modifiers | 0x200 | 8;
            }
        }
        return modifiers;
    }

    private Point getEventPoint(String coordinates) {
        int separatorIndex = coordinates.indexOf(95);
        int x = (int)Float.parseFloat(coordinates.substring(0, separatorIndex));
        int y = (int)Float.parseFloat(coordinates.substring(separatorIndex + 1));
        return new Point(x, y);
    }

    private String getTextSafe(JTextComponent comp) {
        try {
            String text = comp == null ? "" : comp.getText();
            return text;
        }
        catch (Throwable t) {
            return "";
        }
    }
}

