/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.v4;

import com.creamtec.ajaxswing.core.AjaxSwingComponentHint;
import com.creamtec.ajaxswing.core.NameUtils;
import com.creamtec.ajaxswing.rendering.html.HTMLPage;
import com.creamtec.ajaxswing.v4.AjaxSwingV4Handler;
import com.creamtec.ajaxswing.v4.ComponentGraphics;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import javax.swing.JComponent;

public class AjaxSwingV4Renderer {
    public void renderComponent(HTMLPage page, Object component, AjaxSwingV4Handler handler) throws Exception {
        Component comp = (Component)component;
        StringBuilder body = page.getBody();
        body.append("<div class=\"ajaxswingv4");
        String customClass = page.getClientAgent().getComponentProperty((Object)comp, "cssClass");
        Rectangle bounds = comp.getBounds();
        if (customClass != null) {
            body.append(" ");
            body.append(customClass.toString());
        }
        if (comp instanceof Window) {
            page.getRenderContext().setWindowContainer((Container)comp);
            if (bounds.y < 0) {
                comp.setLocation(bounds.x, 0);
            }
            if (bounds.x < 0) {
                comp.setLocation(0, bounds.y);
            }
            bounds = comp.getBounds();
        }
        body.append("\" ");
        body.append("id=\"");
        body.append(page.getComponentName(comp));
        body.append("\" ");
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            jcomp.putClientProperty("ajaxswing.v4root", "true");
        }
        body.append("onContextMenu");
        body.append("=\"return submitMouseMenu('");
        body.append(NameUtils.getComponentName((Object)comp));
        body.append("', event);\" ");
        body.append("onmousewheel =\" return submitMouseWheelEvent('" + page.getComponentName(comp) + "', event); \"");
        body.append("onwheel =\" return submitWheelEvent('" + page.getComponentName(comp) + "', event); \"");
        body.append("style=\"position:absolute;top:");
        body.append(bounds.y);
        body.append("px;left:");
        body.append(bounds.x);
        body.append("px;");
        body.append("width:");
        body.append(bounds.width);
        body.append("px;height:");
        body.append(bounds.height);
        body.append("px;\" ");
        body.append(">");
        handler.registerUpdatable(comp);
        boolean oldAllowed = page.getClientAgent().isFocusChangeAllowed(comp);
        page.getClientAgent().setFocusChangeAllowed(false);
        this.paintComponent(page, comp, handler);
        page.getClientAgent().setFocusChangeAllowed(oldAllowed);
        body.append("</div>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(HTMLPage page, Component comp, AjaxSwingV4Handler handler) {
        ComponentGraphics g = new ComponentGraphics(page, handler);
        if (!(comp instanceof JComponent)) {
            Rectangle bounds = comp.getBounds();
            g.setClip(0, 0, bounds.width, bounds.height);
            g.setV4Root(true);
            page.setV4RootComponent(comp);
            g.setRenderingHint((RenderingHints.Key)AjaxSwingComponentHint.getInstance(), comp);
            try {
                comp.paint(g);
            }
            finally {
                g.setRenderingHint((RenderingHints.Key)AjaxSwingComponentHint.getInstance(), null);
                g.dispose();
            }
        } else {
            comp.paint(g);
        }
    }
}

