/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.ui;

import com.creamtec.ajaxswing.ui.AjaxSwingConsole;
import com.creamtec.ajaxswing.ui.AppWizApplicationPanel;
import com.creamtec.ajaxswing.ui.AppWizCheckListPanel;
import com.creamtec.ajaxswing.ui.AppWizNewEditPanel;
import com.creamtec.ajaxswing.ui.AppWizPanel;
import com.creamtec.ajaxswing.ui.AppWizSummaryPanel;
import com.creamtec.ajaxswing.ui.AppWizWebPropsPanel;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class AppWizard
extends JDialog {
    boolean committed = false;
    JPanel panel1 = new JPanel();
    JButton btnPrevious = new JButton();
    JButton btnCancel = new JButton();
    Border border1;
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton btnNext = new JButton();
    GridLayout gridLayout1 = new GridLayout();
    JButton btnFinish = new JButton();
    AppWizNewEditPanel newEditPanel = new AppWizNewEditPanel();
    AppWizApplicationPanel appPanel = new AppWizApplicationPanel();
    AppWizWebPropsPanel webPanel = new AppWizWebPropsPanel();
    AppWizCheckListPanel checkListPanel = new AppWizCheckListPanel();
    AppWizSummaryPanel summaryPanel = new AppWizSummaryPanel();
    protected boolean dirty = false;
    AppProperties props;
    boolean isNew = true;
    JTabbedPane tabPane = new JTabbedPane(){

        @Override
        public void setSelectedIndex(int index) {
            try {
                if (AppWizard.this.tabPane.getSelectedComponent() != null) {
                    if (((AppWizPanel)AppWizard.this.tabPane.getSelectedComponent()).apply()) {
                        super.setSelectedIndex(index);
                    }
                    ((AppWizPanel)AppWizard.this.tabPane.getSelectedComponent()).activate();
                    AppWizard.this.btnNext.setEnabled(AppWizard.this.tabPane.getSelectedIndex() < AppWizard.this.tabPane.getComponentCount() - 1);
                    AppWizard.this.btnPrevious.setEnabled(true);
                    if (index == AppWizard.this.tabPane.getComponentCount() - 1) {
                        AppWizard.this.btnFinish.setEnabled(true);
                    }
                } else {
                    super.setSelectedIndex(index);
                }
                if (AppWizard.this.isNew && index < AppWizard.this.tabPane.getComponentCount() - 1) {
                    AppWizard.this.tabPane.setEnabledAt(index + 1, true);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                String msg = TraceMgr.getExceptionText((String)"", (Throwable)x);
                JOptionPane.showMessageDialog(this, msg, "Error", 0);
            }
        }
    };
    AjaxSwingConsole console;

    public AppWizard(AjaxSwingConsole frame, String title, boolean modal) {
        super(frame, title, modal);
        this.console = frame;
        try {
            this.jbInit();
            this.tabPane.add("New/Edit", this.newEditPanel);
            this.tabPane.add("Application Properties", this.appPanel);
            this.tabPane.add("Web-enabling Properties", this.webPanel);
            this.tabPane.add("Summary", this.summaryPanel);
            this.newEditPanel.setWizard(this);
            this.appPanel.setWizard(this);
            this.webPanel.setWizard(this);
            this.checkListPanel.setWizard(this);
            this.summaryPanel.setWizard(this);
            this.setSize(640, 400);
            this.newEditPanel.onNew();
            this.getRootPane().setDefaultButton(this.btnNext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AppWizard(AjaxSwingConsole frame, String title) {
        this(frame, title, true);
    }

    public AppWizard(AjaxSwingConsole frame) {
        this(frame, "Application Wizard", true);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createRaisedBevelBorder();
        this.jPanel1.setLayout(this.gridLayout1);
        this.btnPrevious.setEnabled(false);
        this.btnPrevious.setText("Previous");
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppWizard.this.btnPrevious_actionPerformed(e);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppWizard.this.btnCancel_actionPerformed(e);
            }
        });
        this.panel1.setLayout(this.gridBagLayout1);
        this.btnNext.setText("Next");
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppWizard.this.btnNext_actionPerformed(e);
            }
        });
        this.btnFinish.setEnabled(false);
        this.btnFinish.setText("Finish");
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppWizard.this.btnFinish_actionPerformed(e);
            }
        });
        this.setTitle("Application Wizard");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AppWizard.this.this_windowClosing(e);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                AppWizard.this.this_windowOpened(e);
            }
        });
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.jPanel1.add((Component)this.btnPrevious, null);
        this.jPanel1.add((Component)this.btnNext, null);
        this.jPanel1.add((Component)this.btnCancel, null);
        this.jPanel1.add((Component)this.btnFinish, null);
        this.panel1.add((Component)this.tabPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(this.panel1);
    }

    void btnPrevious_actionPerformed(ActionEvent e) {
        this.tabPane.setSelectedIndex(this.tabPane.getSelectedIndex() - 1);
    }

    void checkAndClose() {
        if (this.isDirty()) {
            if (JOptionPane.showConfirmDialog(this, "Changes are not saved. Are you sure you want to close?", "Confirm", 0) == 0) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    boolean isDirty() {
        return this.dirty;
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    void btnNext_actionPerformed(ActionEvent e) {
        this.tabPane.setSelectedIndex(this.tabPane.getSelectedIndex() + 1);
    }

    void btnCancel_actionPerformed(ActionEvent e) {
        this.checkAndClose();
    }

    void this_windowClosing(WindowEvent e) {
        this.checkAndClose();
    }

    void btnFinish_actionPerformed(ActionEvent e) {
        try {
            if (this.tabPane.getSelectedComponent() != null && ((AppWizPanel)this.tabPane.getSelectedComponent()).apply()) {
                this.doSave();
                this.committed = true;
                this.dispose();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            String msg = TraceMgr.getExceptionText((String)"", (Throwable)x);
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
        }
    }

    void doSave() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getAppPropertiesFileName());
            Properties keysToSave = this.getKeysToSave();
            keysToSave.store(fos, "AjaxSwing properties file");
            fos.close();
            String fileName = this.getAppName();
            if (fileName.indexOf(46) != -1) {
                fileName = fileName.substring(0, fileName.indexOf(46));
            }
            String appURL = "http://localhost:8040/ajaxswing/apps/" + fileName;
            JTextArea txaMsg = new JTextArea("Properties file has been successfully saved.\nIf your web server is configured, you can access it via a URL similar to this\n" + appURL + "\n" + "Would you like to preview your application using built-in web server?");
            txaMsg.setBackground(SystemColor.window);
            txaMsg.setEditable(false);
            if (JOptionPane.showConfirmDialog(this, txaMsg, "Success", 0, 3) == 0) {
                if (this.console.webServerManager.webServerRunning) {
                    this.console.mniStopWebserver_actionPerformed(null);
                }
                this.console.mniStartWebserver_actionPerformed(null);
                this.console.showStatus("Type " + appURL + " in the browser to view your application");
                if (this.console.webServerManager.webServerRunning) {
                    if (this.console.webServerManager.windows) {
                        Runtime.getRuntime().exec("..\\bin\\previewApp.bat " + appURL);
                    } else {
                        Runtime.getRuntime().exec("netscape " + appURL);
                    }
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            String msg = TraceMgr.getExceptionText((String)"Error", (Throwable)x);
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
        }
    }

    public String getAppName() {
        if (this.newEditPanel.rbtNew.isSelected()) {
            return this.newEditPanel.txfName.getText();
        }
        return this.newEditPanel.lstApps.getSelectedValue().toString();
    }

    public String getAppPropertiesFileName() {
        String fileName = Utilities.getConfFullPath((String)(this.getAppName() + ".properties"));
        File file = new File(fileName);
        try {
            return file.getCanonicalPath();
        }
        catch (Exception x) {
            x.printStackTrace();
            return file.getAbsolutePath();
        }
    }

    public Properties getKeysToSave() throws Exception {
        AppProperties defaultProps = new AppProperties(Utilities.getConfFullPath((String)"default.properties"));
        Set keySet = this.props.keySet();
        Object[] keys = keySet.toArray();
        Arrays.sort(keys);
        Properties keysToSave = new Properties();
        for (int i = 0; i < keys.length; ++i) {
            Object defaultValue = defaultProps.get(keys[i]);
            String newValue = this.props.get(keys[i]).toString();
            if (newValue.equals(defaultValue)) continue;
            keysToSave.put(keys[i], newValue);
        }
        return keysToSave;
    }

    void this_windowOpened(WindowEvent e) {
        this.newEditPanel.txfName.requestFocus();
    }
}

