/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.ui;

import com.creamtec.ajaxswing.ui.AjaxSwingConsole;
import com.creamtec.ajaxswing.ui.AppWizPanel;
import com.creamtec.core.AppProperties;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class AppWizNewEditPanel
extends AppWizPanel {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Border border1;
    ButtonGroup newEditGroup = new ButtonGroup();
    JRadioButton rbtNew = new JRadioButton();
    JLabel lblAppName = new JLabel();
    JTextField txfName = new JTextField();
    JRadioButton rbtEdit = new JRadioButton();
    JList lstApps = new JList();
    JScrollPane spnApps = new JScrollPane();

    public AppWizNewEditPanel() {
        try {
            this.jbInit();
            this.newEditGroup.add(this.rbtNew);
            this.newEditGroup.add(this.rbtEdit);
            String[] files = AjaxSwingConsole.getAppsList();
            if (files != null && files.length != 0) {
                this.lstApps.setListData(files);
                this.lstApps.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.rbtNew.setSelected(true);
        this.rbtNew.setText("New application");
        this.rbtNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppWizNewEditPanel.this.rbtNew_actionPerformed(e);
            }
        });
        this.setLayout(this.gridBagLayout1);
        this.setBorder(this.border1);
        this.lblAppName.setMinimumSize(new Dimension(240, 26));
        this.lblAppName.setPreferredSize(new Dimension(240, 26));
        this.lblAppName.setText("<html>Application Name. <font size=2><i>Used as application URL, so must contain no spaces or control characters</i></font></html>");
        this.rbtEdit.setText("Edit existing application");
        this.rbtEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppWizNewEditPanel.this.rbtEdit_actionPerformed(e);
            }
        });
        this.lstApps.setSelectionMode(0);
        this.add((Component)this.rbtNew, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblAppName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 18, 0, 0), 0, 0));
        this.add((Component)this.rbtEdit, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.txfName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 18, 0, 0), 0, 0));
        this.add((Component)this.spnApps, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 18, 0, 0), 0, 0));
        this.spnApps.getViewport().add((Component)this.lstApps, null);
    }

    @Override
    public boolean apply() throws Exception {
        TraceMgr.trace((Object)this, (String)"apply");
        if (this.rbtNew.isSelected()) {
            if (this.txfName.getText().length() == 0) {
                throw new Exception("Application name is missing");
            }
            String fileName = Utilities.getConfFullPath((String)(this.txfName.getText() + ".properties"));
            if (new File(fileName).exists() && JOptionPane.showConfirmDialog(this, "Do you want to overwrite the existing file?", "Confirm", 0) != 0) {
                return false;
            }
            this.getWizard().props = new AppProperties(Utilities.getConfFullPath((String)"default.properties"));
        } else {
            if (this.lstApps.getSelectedValue() == null) {
                throw new Exception("Please select the application that you want to edit");
            }
            String fileName = Utilities.getConfFullPath((String)(this.lstApps.getSelectedValue().toString() + ".properties"));
            this.getWizard().props = new AppProperties(fileName);
        }
        this.wizard.setDirty(true);
        return true;
    }

    void rbtNew_actionPerformed(ActionEvent e) {
        this.onNew();
    }

    void rbtEdit_actionPerformed(ActionEvent e) {
        this.onEdit();
    }

    void onNew() {
        this.getWizard().isNew = true;
        this.rbtNew.setSelected(true);
        this.txfName.setEnabled(true);
        this.lstApps.setEnabled(false);
        this.getWizard().btnFinish.setEnabled(false);
        for (int i = 2; i < this.getWizard().tabPane.getComponentCount(); ++i) {
            this.getWizard().tabPane.setEnabledAt(i, false);
        }
    }

    void onEdit() {
        this.getWizard().isNew = false;
        this.txfName.setEnabled(false);
        this.lstApps.setEnabled(true);
        this.getWizard().btnFinish.setEnabled(true);
        for (int i = 2; i < this.getWizard().tabPane.getComponentCount(); ++i) {
            this.getWizard().tabPane.setEnabledAt(i, true);
        }
    }
}

