/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.rendering.html.positioned;

import com.creamtec.ajaxswing.rendering.html.positioned.AjaxPage;
import com.creamtec.ajaxswing.rendering.html.positioned.ComponentState;
import com.creamtec.ajaxswing.rendering.html.positioned.PageInterval;
import com.creamtec.core.TraceMgr;
import java.util.ArrayList;
import java.util.List;

public class AjaxComponentState {
    protected ComponentState state;
    public List<PageInterval> pageIntervals = new ArrayList<PageInterval>();
    private int hash;
    public boolean partialUpdateAllowed;
    protected boolean ignoreThisState;
    public Object component;

    public AjaxComponentState(Object component, AjaxPage ajaxPage, String namePostfix) {
        this.state = new ComponentState(component, ajaxPage, namePostfix);
        this.component = component;
    }

    public void computeHash(AjaxPage page) {
        this.hash = 0;
        if (this.getState().getComponentId() != null) {
            this.hash += this.getState().getComponentId().hashCode();
        }
        if (this.getState().getParentId() != null) {
            this.hash += this.getState().getParentId().hashCode();
        }
        for (int i = 0; i < this.pageIntervals.size(); ++i) {
            PageInterval interval = this.pageIntervals.get(i);
            if (interval.output != null) {
                this.hash += interval.output.substring(interval.start, interval.end).hashCode();
                continue;
            }
            TraceMgr.trace((Object)this, (String)("*** WARNING: null output for compid = " + this.getState().getComponentId() + " start = " + interval.start + ", end= " + interval.end), (int)3);
        }
        if (this.getState().getJavaScript() != null) {
            this.hash += this.getState().getJavaScript().hashCode();
        }
    }

    public PageInterval getFirstInterval() {
        return this.pageIntervals.get(0);
    }

    public PageInterval getLastInterval() {
        return this.pageIntervals.get(this.pageIntervals.size() - 1);
    }

    public void startInterval(AjaxPage ajaxPage) {
        if (this.pageIntervals.size() <= 0 || this.getLastInterval().end != ajaxPage.getBody().length()) {
            PageInterval interval = new PageInterval();
            interval.start = ajaxPage.getBody().length();
            this.pageIntervals.add(interval);
        }
    }

    public void endInterval(AjaxPage ajaxPage) {
        if (ajaxPage.getBody().length() > this.getLastInterval().start) {
            this.getLastInterval().end = ajaxPage.getBody().length();
            this.getLastInterval().output = ajaxPage.getBody();
        } else {
            this.pageIntervals.remove(this.pageIntervals.size() - 1);
        }
    }

    public List<PageInterval> getPageIntervals() {
        return this.pageIntervals;
    }

    public void setPageIntervals(List<PageInterval> pageIntervals) {
        this.pageIntervals = pageIntervals;
    }

    public int getHash() {
        return this.hash;
    }

    public void setHash(int hash) {
        this.hash = hash;
    }

    public ComponentState getState() {
        return this.state;
    }

    public void setState(ComponentState state) {
        this.state = state;
    }

    public void setIgnoreThisState(boolean ignore) {
        this.ignoreThisState = ignore;
    }

    public boolean ignoreThisState() {
        return this.ignoreThisState;
    }

    public boolean hasIntervals() {
        return this.pageIntervals.size() > 0;
    }
}

