/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.rendering;

import com.creamtec.ajaxswing.core.AjaxSwingException;
import com.creamtec.core.Utilities;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public class TemplateEngine {
    private static TemplateEngine instance;
    protected Configuration cfg;

    private TemplateEngine() {
        String templatesPath = Utilities.getConfFullPath((String)"templates");
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        this.cfg = new Configuration();
        try {
            this.cfg.setDirectoryForTemplateLoading(new File(templatesPath));
        }
        catch (IOException e) {
            throw new AjaxSwingException("Failed to create Freemarker configuration", (Throwable)e);
        }
        this.cfg.setTemplateUpdateDelay(0);
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        this.cfg.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        this.cfg.setDefaultEncoding("ISO-8859-1");
        this.cfg.setOutputEncoding("UTF-8");
        this.cfg.setLocale(Locale.US);
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public static TemplateEngine getInstance() {
        if (instance == null) {
            instance = new TemplateEngine();
        }
        return instance;
    }
}

