/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.laf.ui;

import com.creamtec.ajaxswing.laf.AjaxSwingLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class AjaxSwingTabbedPaneUI
extends MetalTabbedPaneUI {
    private Color unselectedBackground;
    private boolean tabsOpaque = true;
    private final boolean ocean = true;
    private Color oceanSelectedBorderColor;

    public static ComponentUI createUI(JComponent b) {
        return new AjaxSwingTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.unselectedBackground = UIManager.getColor("TabbedPane.unselectedBackground");
        this.oceanSelectedBorderColor = this.darkShadow;
    }

    @Override
    protected void paintTopTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int currentRun = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        int lastIndex = this.lastTabInRun(this.tabPane.getTabCount(), currentRun);
        int firstIndex = this.tabRuns[currentRun];
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        int selectedIndex = this.tabPane.getSelectedIndex();
        if (!isSelected) {
            y += 2;
            h -= 2;
        }
        int bottom = h - 1;
        int right = w - 1;
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            if (leftToRight) {
                g.setColor(this.getColorForGap(currentRun, x, y + 1));
                g.fillRect(1, 0, 5, 3);
                g.fillRect(1, 3, 2, 2);
            } else {
                g.setColor(this.getColorForGap(currentRun, x + w - 1, y + 1));
                g.fillRect(right - 5, 0, 5, 3);
                g.fillRect(right - 2, 3, 2, 2);
            }
            g.translate(-x, -y);
        }
        g.translate(x, y);
        if (isSelected) {
            g.setColor(this.oceanSelectedBorderColor);
        } else {
            g.setColor(this.darkShadow);
        }
        if (leftToRight) {
            int plus = isSelected && tabIndex != lastIndex ? 1 : 0;
            g.drawLine(0, 0, right + plus, 0);
            if (tabIndex == lastIndex || isSelected) {
                g.drawLine(right + plus, 1, right + plus, bottom);
            }
            if (tabIndex - 1 == selectedIndex && currentRun == this.getRunForTab(this.tabPane.getTabCount(), selectedIndex)) {
                g.setColor(this.oceanSelectedBorderColor);
            }
            if (tabIndex != this.tabRuns[this.runCount - 1]) {
                if (isSelected) {
                    g.drawLine(0, 0, 0, bottom);
                    g.setColor(this.darkShadow);
                    g.drawLine(0, 0, 0, 5);
                } else {
                    g.drawLine(0, 0, 0, bottom);
                }
            } else {
                g.drawLine(0, 0, 0, bottom);
            }
        } else {
            g.drawLine(right - 1, 5, right - 6, 0);
            g.drawLine(right - 6, 0, 0, 0);
            if (tabIndex == lastIndex) {
                g.drawLine(0, 1, 0, bottom);
            }
            if (tabIndex - 1 == selectedIndex && currentRun == this.getRunForTab(this.tabPane.getTabCount(), selectedIndex)) {
                g.setColor(this.oceanSelectedBorderColor);
                g.drawLine(right, 0, right, bottom);
            } else if (isSelected) {
                g.drawLine(right, 6, right, bottom);
                if (tabIndex != 0) {
                    g.setColor(this.darkShadow);
                    g.drawLine(right, 0, right, 5);
                }
            } else if (tabIndex != this.tabRuns[this.runCount - 1]) {
                g.drawLine(right, 0, right, bottom);
            } else {
                g.drawLine(right, 6, right, bottom);
            }
        }
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        if (leftToRight) {
            g.drawLine(1, 1, tabIndex == lastIndex ? right - 1 : right, 1);
            g.drawLine(1, 1, 1, bottom);
            if (tabIndex == firstIndex && tabIndex != this.tabRuns[this.runCount - 1]) {
                if (this.tabPane.getSelectedIndex() == this.tabRuns[currentRun + 1]) {
                    g.setColor(this.selectHighlight);
                } else {
                    g.setColor(this.highlight);
                }
                g.drawLine(1, 0, 1, 4);
            }
        } else {
            g.drawLine(right - 1, 6, right - 6, 1);
            g.drawLine(right - 6, 1, 1, 1);
            if (tabIndex == lastIndex) {
                g.drawLine(1, 1, 1, bottom);
            } else {
                g.drawLine(0, 1, 0, bottom);
            }
        }
        g.translate(-x, -y);
    }

    @Override
    protected void paintLeftTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int plus;
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        if (!isSelected) {
            x += 2;
            w -= 2;
        }
        g.translate(x, y);
        int bottom = h - 1;
        int right = w - 1;
        if (tabIndex != firstIndex && this.tabsOpaque) {
            g.setColor(this.tabPane.getSelectedIndex() == tabIndex - 1 ? this.selectColor : this.getUnselectedBackgroundAt(tabIndex - 1));
            g.fillRect(2, 0, 4, 3);
            g.drawLine(2, 3, 2, 3);
        }
        g.setColor(isSelected ? this.selectHighlight : AjaxSwingLookAndFeel.getWhite());
        g.drawLine(1, 1, 1, bottom);
        g.drawLine(1, 1, right, 1);
        if (tabIndex != firstIndex) {
            if (this.tabPane.getSelectedIndex() == tabIndex - 1) {
                g.setColor(this.selectHighlight);
            } else {
                g.setColor(AjaxSwingLookAndFeel.getWhite());
            }
            g.drawLine(1, 0, 1, 4);
        }
        if (isSelected) {
            g.setColor(this.oceanSelectedBorderColor);
        } else {
            g.setColor(this.darkShadow);
        }
        g.drawLine(0, 0, right, 0);
        int n = plus = isSelected && tabIndex != lastIndex ? 1 : 0;
        if (tabIndex == lastIndex || isSelected) {
            g.drawLine(0, bottom + plus, right, bottom + plus);
        }
        if (this.tabPane.getSelectedIndex() == tabIndex - 1) {
            g.drawLine(0, 0, 0, bottom);
            g.setColor(this.oceanSelectedBorderColor);
            g.drawLine(0, 0, 0, 5);
        } else if (isSelected) {
            g.drawLine(0, 0, 0, bottom);
            if (tabIndex != 0) {
                g.setColor(this.darkShadow);
                g.drawLine(0, 0, 0, 5);
            }
        } else if (tabIndex != firstIndex) {
            g.drawLine(0, 0, 0, bottom);
        } else {
            g.drawLine(0, 0, 0, bottom);
        }
        g.translate(-x, -y);
    }

    @Override
    protected void paintBottomTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        if (!isSelected) {
            y -= 2;
            h -= 2;
        }
        int bottom = h - 1;
        int right = w - 1;
        if (this.shouldFillGap(currentRun, tabIndex, x, y)) {
            g.translate(x, y);
            if (leftToRight) {
                g.setColor(this.getColorForGap(currentRun, x, y));
                g.fillRect(1, bottom - 4, 3, 5);
                g.fillRect(4, bottom - 1, 2, 2);
            } else {
                g.setColor(this.getColorForGap(currentRun, x + w - 1, y));
                g.fillRect(right - 3, bottom - 3, 3, 4);
                g.fillRect(right - 5, bottom - 1, 2, 2);
                g.drawLine(right - 1, bottom - 4, right - 1, bottom - 4);
            }
            g.translate(-x, -y);
        }
        g.translate(x, y);
        if (isSelected) {
            g.setColor(this.oceanSelectedBorderColor);
        } else {
            g.setColor(this.darkShadow);
        }
        if (leftToRight) {
            int plus;
            g.drawLine(0, bottom, right, bottom);
            int n = plus = isSelected && tabIndex != lastIndex ? 1 : 0;
            if (tabIndex == lastIndex || isSelected) {
                g.drawLine(right + plus, 0, right + plus, bottom);
            }
            if (isSelected) {
                g.drawLine(0, 0, 0, bottom);
                if (currentRun == 0 && tabIndex != 0 || currentRun > 0 && tabIndex != this.tabRuns[currentRun - 1]) {
                    g.setColor(this.darkShadow);
                    g.drawLine(0, bottom, 0, bottom);
                }
            } else {
                if (tabIndex == this.tabPane.getSelectedIndex() + 1) {
                    g.setColor(this.oceanSelectedBorderColor);
                }
                if (tabIndex != this.tabRuns[this.runCount - 1]) {
                    g.drawLine(0, 0, 0, bottom);
                } else {
                    g.drawLine(0, 0, 0, bottom);
                }
            }
        } else {
            g.drawLine(right - 1, bottom - 5, right - 6, bottom);
            g.drawLine(right - 6, bottom, 0, bottom);
            if (tabIndex == lastIndex) {
                g.drawLine(0, 0, 0, bottom);
            }
            if (tabIndex == this.tabPane.getSelectedIndex() + 1) {
                g.setColor(this.oceanSelectedBorderColor);
                g.drawLine(right, 0, right, bottom);
            } else if (isSelected) {
                g.drawLine(right, 0, right, bottom - 6);
                if (tabIndex != firstIndex) {
                    g.setColor(this.darkShadow);
                    g.drawLine(right, bottom - 5, right, bottom);
                }
            } else if (tabIndex != this.tabRuns[this.runCount - 1]) {
                g.drawLine(right, 0, right, bottom);
            } else {
                g.drawLine(right, 0, right, bottom - 6);
            }
        }
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        if (leftToRight) {
            g.drawLine(1, bottom - 6, 6, bottom - 1);
            g.drawLine(1, 0, 1, bottom - 6);
            if (tabIndex == firstIndex && tabIndex != this.tabRuns[this.runCount - 1]) {
                if (this.tabPane.getSelectedIndex() == this.tabRuns[currentRun + 1]) {
                    g.setColor(this.selectHighlight);
                } else {
                    g.setColor(this.highlight);
                }
                g.drawLine(1, bottom - 4, 1, bottom);
            }
        } else if (tabIndex == lastIndex) {
            g.drawLine(1, 0, 1, bottom - 1);
        } else {
            g.drawLine(0, 0, 0, bottom - 1);
        }
        g.translate(-x, -y);
    }

    @Override
    protected void paintRightTabBorder(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        int plus;
        int tabCount = this.tabPane.getTabCount();
        int currentRun = this.getRunForTab(tabCount, tabIndex);
        int lastIndex = this.lastTabInRun(tabCount, currentRun);
        int firstIndex = this.tabRuns[currentRun];
        if (!isSelected) {
            x -= 2;
            w -= 2;
        }
        g.translate(x, y);
        int bottom = h - 1;
        int right = w - 1;
        if (tabIndex != firstIndex && this.tabsOpaque) {
            g.setColor(this.tabPane.getSelectedIndex() == tabIndex - 1 ? this.selectColor : this.getUnselectedBackgroundAt(tabIndex - 1));
            g.fillRect(right - 5, 0, 5, 3);
            g.fillRect(right - 2, 3, 2, 2);
        }
        g.setColor(isSelected ? this.selectHighlight : this.highlight);
        g.drawLine(0, 1, right, 1);
        if (!isSelected) {
            g.drawLine(0, 1, 0, bottom);
        }
        if (isSelected) {
            g.setColor(this.oceanSelectedBorderColor);
        } else {
            g.setColor(this.darkShadow);
        }
        int n = plus = isSelected && tabIndex != lastIndex ? 1 : 0;
        if (tabIndex == lastIndex || isSelected) {
            g.drawLine(0, bottom + plus, right, bottom + plus);
        }
        if (this.tabPane.getSelectedIndex() == tabIndex - 1) {
            g.setColor(this.oceanSelectedBorderColor);
        }
        g.drawLine(0, 0, right, 0);
        if (isSelected) {
            g.drawLine(right, 0, right, bottom);
            if (tabIndex != firstIndex) {
                g.setColor(this.darkShadow);
                g.drawLine(right, 0, right, 5);
            }
        } else if (this.tabPane.getSelectedIndex() == tabIndex - 1) {
            g.setColor(this.darkShadow);
            g.drawLine(right, 0, right, bottom);
        } else if (tabIndex != firstIndex) {
            g.drawLine(right, 0, right, bottom);
        } else {
            g.drawLine(right, 0, right, bottom);
        }
        g.translate(-x, -y);
    }

    private Color getUnselectedBackgroundAt(int index) {
        Color color = this.tabPane.getBackgroundAt(index);
        if (color instanceof UIResource && this.unselectedBackground != null) {
            return this.unselectedBackground;
        }
        return color;
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        int right = x + w - 1;
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        g.setColor(this.oceanSelectedBorderColor);
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
            g.drawLine(x, y, x + w - 2, y);
            if (tabPlacement == 1) {
                g.setColor(AjaxSwingLookAndFeel.getWhite());
                g.drawLine(x, y + 1, x + w - 2, y + 1);
            }
        } else {
            boolean lastInRun = this.isLastInRun(selectedIndex);
            if (leftToRight || lastInRun) {
                g.drawLine(x, y, selRect.x, y);
            } else {
                g.drawLine(x, y, selRect.x, y);
            }
            if (selRect.x + selRect.width < right - 1) {
                if (leftToRight && !lastInRun) {
                    g.drawLine(selRect.x + selRect.width, y, right - 1, y);
                } else {
                    g.drawLine(selRect.x + selRect.width - 1, y, right - 1, y);
                }
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y, x + w - 2, y);
            }
            g.setColor(AjaxSwingLookAndFeel.getWhite());
            if (leftToRight || lastInRun) {
                g.drawLine(x, y + 1, selRect.x + 1, y + 1);
            } else {
                g.drawLine(x, y + 1, selRect.x, y + 1);
            }
            if (selRect.x + selRect.width < right - 1) {
                if (leftToRight && !lastInRun) {
                    g.drawLine(selRect.x + selRect.width, y + 1, right - 1, y + 1);
                } else {
                    g.drawLine(selRect.x + selRect.width - 1, y + 1, right - 1, y + 1);
                }
            } else {
                g.setColor(this.shadow);
                g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
            }
        }
    }

    private boolean isLastInRun(int tabIndex) {
        int run = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        int lastIndex = this.lastTabInRun(this.tabPane.getTabCount(), run);
        return tabIndex == lastIndex;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        if (tabPlacement == 3) {
            return super.getTabLabelShiftY(tabPlacement, tabIndex, isSelected) + (isSelected ? 1 : 0);
        }
        return super.getTabLabelShiftY(tabPlacement, tabIndex, isSelected) + (isSelected ? 1 : 2);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            g.setColor(this.selectColor);
        } else {
            g.setColor(this.getUnselectedBackgroundAt(tabIndex));
        }
        boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
        if (leftToRight) {
            switch (tabPlacement) {
                case 2: {
                    g.fillRect(x + 5, y + 1, w - 5, h - 1);
                    g.fillRect(x + 2, y + 4, 3, h - 4);
                    break;
                }
                case 3: {
                    g.fillRect(x + 2, y, w - 2, h - 4);
                    g.fillRect(x + 5, y + (h - 1) - 3, w - 5, 3);
                    break;
                }
                case 4: {
                    g.fillRect(x, y + 2, w - 4, h - 2);
                    g.fillRect(x + (w - 1) - 3, y + 5, 3, h - 5);
                    break;
                }
                default: {
                    g.fillRect(x + 1, y + 2, w - 1, h - 1 - 1);
                    break;
                }
            }
        } else {
            switch (tabPlacement) {
                case 2: {
                    g.fillRect(x + 5, y + 1, w - 5, h - 1);
                    g.fillRect(x + 2, y + 4, 3, h - 4);
                    break;
                }
                case 3: {
                    g.fillRect(x, y, w - 5, h - 1);
                    g.fillRect(x + (w - 1) - 4, y, 4, h - 5);
                    g.fillRect(x + (w - 1) - 4, y + (h - 1) - 4, 2, 2);
                    break;
                }
                case 4: {
                    g.fillRect(x + 1, y + 1, w - 5, h - 1);
                    g.fillRect(x + (w - 1) - 3, y + 5, 3, h - 5);
                    break;
                }
                default: {
                    g.fillRect(x, y + 2, w - 1 - 3, h - 1 - 1);
                    g.fillRect(x + (w - 1) - 3, y + 5, 3, h - 3);
                }
            }
        }
    }
}

