/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.laf.ui;

import com.creamtec.ajaxswing.core.NameUtils;
import com.creamtec.ajaxswing.v4.ComponentGraphics;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class AjaxSwingScrollBarUI
extends MetalScrollBarUI {
    public static NumberFormat format = NumberFormat.getInstance(Locale.US);

    public AjaxSwingScrollBarUI() {
        format.setGroupingUsed(false);
        if (format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern("#.#####");
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new AjaxSwingScrollBarUI();
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        ComponentGraphics cg;
        if (g instanceof ComponentGraphics) {
            cg = (ComponentGraphics)g;
            Rectangle trackBounds = this.getTrackBounds();
            cg.append("<div class=\"track\" style=\"position:absolute;left:");
            cg.append(trackBounds.x);
            cg.append("px;top:");
            cg.append(trackBounds.y);
            cg.append("px;width:");
            cg.append(trackBounds.width);
            cg.append("px;height:");
            cg.append(trackBounds.height + "px;\">");
            cg.translateNoClip(-trackBounds.x, -trackBounds.y);
            cg.append("<div class=\"thumb\" style=\"position:absolute;left:");
            cg.append(thumbBounds.x - trackBounds.x);
            cg.append("px;top:");
            cg.append(thumbBounds.y - trackBounds.y);
            cg.append("px;width:");
            cg.append(thumbBounds.width);
            cg.append("px;height:");
            cg.append(thumbBounds.height + "px;\"");
            if (c.getParent() instanceof JScrollPane) {
                Rectangle visibleSize;
                JViewport viewport = ((JScrollPane)c.getParent()).getViewport();
                Dimension totalSize = viewport == null ? null : viewport.getViewSize();
                Rectangle rectangle = visibleSize = viewport == null ? null : viewport.getViewRect();
                if (totalSize != null && visibleSize != null && visibleSize.width > 0 && visibleSize.height > 0) {
                    float perX = (float)totalSize.width / (float)visibleSize.width;
                    cg.append(" scrollWidthPerPxX=\"");
                    cg.append(format.format(perX));
                    cg.append("\"");
                    float perY = (float)totalSize.height / (float)visibleSize.height;
                    cg.append(" scrollWidthPerPxY=\"");
                    cg.append(format.format(perY));
                    cg.append("\"");
                    cg.append(" scrollViewportId=\"");
                    cg.append(NameUtils.getComponentName((Object)viewport));
                    cg.append("\"");
                }
            }
            cg.append(">");
            cg.translateNoClip(-(thumbBounds.x - trackBounds.x), -(thumbBounds.y - trackBounds.y));
        }
        super.paintThumb(g, c, thumbBounds);
        if (g instanceof ComponentGraphics) {
            cg = (ComponentGraphics)g;
            cg.append("</div>");
            cg.append("</div>");
        }
    }
}

