/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.laf;

import com.creamtec.ajaxswing.laf.AjaxSwingLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.plaf.UIResource;

public class AjaxSwingIconFactory
implements Serializable {
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon checkBoxIcon;
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;
    public static final boolean USING_OCEAN = true;
    private static final Dimension menuCheckIconSize;
    private static final int xOff = 4;

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getMenuItemCheckIcon() {
        return null;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static void drawBackground(Component c, Graphics g, String key, int x, int y, int width, int height, boolean b) {
        if ("CheckBox.gradient".equals(key) || "RadioButton.gradient".equals(key)) {
            Color old = g.getColor();
            g.setColor(Color.WHITE);
            g.fillRect(x, y, width, height);
            g.setColor(old);
        }
    }

    public static boolean isLeftToRight(Component c) {
        if (c == null) {
            return true;
        }
        return c.getComponentOrientation().isLeftToRight();
    }

    static {
        menuCheckIconSize = new Dimension(10, 10);
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        public void paintOceanIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model = ((JMenuItem)c).getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                AjaxSwingIconFactory.drawBackground(c, g, "RadioButtonMenuItem.gradient", 1, 1, 7, 7, true);
                if (isPressed || isArmed) {
                    g.setColor(AjaxSwingLookAndFeel.getPrimaryControl());
                } else {
                    g.setColor(AjaxSwingLookAndFeel.getControlHighlight());
                }
                g.drawLine(2, 9, 7, 9);
                g.drawLine(9, 2, 9, 7);
                g.drawLine(8, 8, 8, 8);
                if (isPressed || isArmed) {
                    g.setColor(AjaxSwingLookAndFeel.getControlInfo());
                } else {
                    g.setColor(AjaxSwingLookAndFeel.getControlDarkShadow());
                }
            } else {
                g.setColor(AjaxSwingLookAndFeel.getMenuDisabledForeground());
            }
            g.drawLine(2, 0, 6, 0);
            g.drawLine(2, 8, 6, 8);
            g.drawLine(0, 2, 0, 6);
            g.drawLine(8, 2, 8, 6);
            g.drawLine(1, 1, 1, 1);
            g.drawLine(7, 1, 7, 1);
            g.drawLine(1, 7, 1, 7);
            g.drawLine(7, 7, 7, 7);
            if (isSelected) {
                if (isEnabled) {
                    if (isArmed || c instanceof JMenu && model.isSelected()) {
                        g.setColor(AjaxSwingLookAndFeel.getMenuSelectedForeground());
                    } else {
                        g.setColor(AjaxSwingLookAndFeel.getControlInfo());
                    }
                } else {
                    g.setColor(AjaxSwingLookAndFeel.getMenuDisabledForeground());
                }
                g.drawLine(3, 2, 5, 2);
                g.drawLine(2, 3, 6, 3);
                g.drawLine(2, 4, 6, 4);
                g.drawLine(2, 5, 6, 5);
                g.drawLine(3, 6, 5, 6);
            }
            g.translate(-x, -y);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintOceanIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        @Override
        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintOceanIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model = ((JMenuItem)c).getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                AjaxSwingIconFactory.drawBackground(c, g, "CheckBoxMenuItem.gradient", 1, 1, 7, 7, true);
                if (isPressed || isArmed) {
                    g.setColor(AjaxSwingLookAndFeel.getControlInfo());
                    g.drawLine(0, 0, 8, 0);
                    g.drawLine(0, 0, 0, 8);
                    g.drawLine(8, 2, 8, 8);
                    g.drawLine(2, 8, 8, 8);
                    g.setColor(AjaxSwingLookAndFeel.getPrimaryControl());
                    g.drawLine(9, 1, 9, 9);
                    g.drawLine(1, 9, 9, 9);
                } else {
                    g.setColor(AjaxSwingLookAndFeel.getControlDarkShadow());
                    g.drawLine(0, 0, 8, 0);
                    g.drawLine(0, 0, 0, 8);
                    g.drawLine(8, 2, 8, 8);
                    g.drawLine(2, 8, 8, 8);
                    g.setColor(AjaxSwingLookAndFeel.getControlHighlight());
                    g.drawLine(9, 1, 9, 9);
                    g.drawLine(1, 9, 9, 9);
                }
            } else {
                g.setColor(AjaxSwingLookAndFeel.getMenuDisabledForeground());
                g.drawRect(0, 0, 8, 8);
            }
            if (isSelected) {
                if (isEnabled) {
                    if (isArmed || c instanceof JMenu && isSelected) {
                        g.setColor(AjaxSwingLookAndFeel.getMenuSelectedForeground());
                    } else {
                        g.setColor(AjaxSwingLookAndFeel.getControlInfo());
                    }
                } else {
                    g.setColor(AjaxSwingLookAndFeel.getMenuDisabledForeground());
                }
                g.drawLine(2, 2, 2, 6);
                g.drawLine(3, 2, 3, 6);
                g.drawLine(4, 4, 8, 0);
                g.drawLine(4, 5, 9, 0);
            }
            g.translate(-x, -y);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintOceanIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        @Override
        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    static class ImageCacher {
        Vector images = new Vector(1, 1);
        ImageGcPair currentImageGcPair;

        ImageCacher() {
        }

        Image getImage(GraphicsConfiguration newGC) {
            if (this.currentImageGcPair == null || !this.currentImageGcPair.hasSameConfiguration(newGC)) {
                Enumeration elements = this.images.elements();
                while (elements.hasMoreElements()) {
                    ImageGcPair imgGcPair = (ImageGcPair)elements.nextElement();
                    if (!imgGcPair.hasSameConfiguration(newGC)) continue;
                    this.currentImageGcPair = imgGcPair;
                    return imgGcPair.image;
                }
                return null;
            }
            return this.currentImageGcPair.image;
        }

        void cacheImage(Image image, GraphicsConfiguration gc) {
            ImageGcPair imgGcPair = new ImageGcPair(image, gc);
            this.images.addElement(imgGcPair);
            this.currentImageGcPair = imgGcPair;
        }

        class ImageGcPair {
            Image image;
            GraphicsConfiguration gc;

            ImageGcPair(Image image, GraphicsConfiguration gc) {
                this.image = image;
                this.gc = gc;
            }

            boolean hasSameConfiguration(GraphicsConfiguration newGC) {
                return newGC != null && newGC.equals(this.gc) || newGC == null && this.gc == null;
            }
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        public void paintOceanIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model = ((JRadioButton)c).getModel();
            boolean enabled = model.isEnabled();
            boolean pressed = enabled && model.isPressed() && model.isArmed();
            boolean rollover = enabled && model.isRollover();
            g.translate(x, y);
            if (enabled && !pressed) {
                AjaxSwingIconFactory.drawBackground(c, g, "RadioButton.gradient", 1, 1, 10, 10, true);
                g.setColor(c.getBackground());
                g.fillRect(1, 1, 1, 1);
                g.fillRect(10, 1, 1, 1);
                g.fillRect(1, 10, 1, 1);
                g.fillRect(10, 10, 1, 1);
            } else if (pressed || !enabled) {
                if (pressed) {
                    g.setColor(AjaxSwingLookAndFeel.getPrimaryControl());
                } else {
                    g.setColor(AjaxSwingLookAndFeel.getControl());
                }
                g.fillRect(2, 2, 8, 8);
                g.fillRect(4, 1, 4, 1);
                g.fillRect(4, 10, 4, 1);
                g.fillRect(1, 4, 1, 4);
                g.fillRect(10, 4, 1, 4);
            }
            if (!enabled) {
                g.setColor(AjaxSwingLookAndFeel.getInactiveControlTextColor());
            } else {
                g.setColor(AjaxSwingLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(4, 0, 7, 0);
            g.drawLine(8, 1, 9, 1);
            g.drawLine(10, 2, 10, 3);
            g.drawLine(11, 4, 11, 7);
            g.drawLine(10, 8, 10, 9);
            g.drawLine(9, 10, 8, 10);
            g.drawLine(7, 11, 4, 11);
            g.drawLine(3, 10, 2, 10);
            g.drawLine(1, 9, 1, 8);
            g.drawLine(0, 7, 0, 4);
            g.drawLine(1, 3, 1, 2);
            g.drawLine(2, 1, 3, 1);
            if (pressed) {
                g.fillRect(1, 4, 1, 4);
                g.fillRect(2, 2, 1, 2);
                g.fillRect(3, 2, 1, 1);
                g.fillRect(4, 1, 4, 1);
            } else if (rollover) {
                g.setColor(AjaxSwingLookAndFeel.getPrimaryControl());
                g.fillRect(4, 1, 4, 2);
                g.fillRect(8, 2, 2, 2);
                g.fillRect(9, 4, 2, 4);
                g.fillRect(8, 8, 2, 2);
                g.fillRect(4, 9, 4, 2);
                g.fillRect(2, 8, 2, 2);
                g.fillRect(1, 4, 2, 4);
                g.fillRect(2, 2, 2, 2);
            }
            if (model.isSelected()) {
                if (enabled) {
                    g.setColor(AjaxSwingLookAndFeel.getControlInfo());
                } else {
                    g.setColor(AjaxSwingLookAndFeel.getControlDarkShadow());
                }
                g.fillRect(4, 4, 4, 4);
                g.drawLine(4, 3, 7, 3);
                g.drawLine(8, 4, 8, 7);
                g.drawLine(7, 8, 4, 8);
                g.drawLine(3, 7, 3, 4);
            }
            g.translate(-x, -y);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintOceanIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        private void paintOceanIcon(Component c, Graphics g, int x, int y) {
            ButtonModel model = ((JCheckBox)c).getModel();
            g.translate(x, y);
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(AjaxSwingLookAndFeel.getControlShadow());
                    g.fillRect(0, 0, w, h);
                    g.setColor(AjaxSwingLookAndFeel.getControlDarkShadow());
                    g.fillRect(0, 0, w, 2);
                    g.fillRect(0, 2, 2, h - 2);
                    g.fillRect(w - 1, 1, 1, h - 1);
                    g.fillRect(1, h - 1, w - 2, 1);
                } else if (model.isRollover()) {
                    AjaxSwingIconFactory.drawBackground(c, g, "CheckBox.gradient", 0, 0, w, h, true);
                    g.setColor(AjaxSwingLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                    g.setColor(AjaxSwingLookAndFeel.getPrimaryControl());
                    g.drawRect(1, 1, w - 3, h - 3);
                    g.drawRect(2, 2, w - 5, h - 5);
                } else {
                    AjaxSwingIconFactory.drawBackground(c, g, "CheckBox.gradient", 0, 0, w, h, true);
                    g.setColor(AjaxSwingLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                }
                g.setColor(AjaxSwingLookAndFeel.getControlInfo());
            } else {
                g.setColor(AjaxSwingLookAndFeel.getControlDarkShadow());
                g.drawRect(0, 0, w - 1, h - 1);
            }
            g.translate(-x, -y);
            if (model.isSelected()) {
                this.drawCheck(c, g, x, y);
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintOceanIcon(c, g, x, y);
        }

        protected void drawCheck(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.fillRect(x + 3, y + 5, 2, controlSize - 8);
            g.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
            g.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

