/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing.examples;

import com.creamtec.ajaxswing.core.ActionData;
import com.creamtec.ajaxswing.core.AgentRequestFilter;
import com.creamtec.ajaxswing.core.ClientAgent;
import com.creamtec.ajaxswing.core.HttpResponseData;
import com.creamtec.core.TraceMgr;
import java.awt.Window;
import java.util.List;
import javax.swing.JDialog;

public class AgentRequestFilterExample
implements AgentRequestFilter {
    public AgentRequestFilterExample() {
        TraceMgr.trace((Object)this, (String)"Filter loaded");
    }

    public HttpResponseData preProcessRequest(ClientAgent agent) {
        TraceMgr.trace((Object)this, (String)"preProcessRequest");
        try {
            String action;
            if ("About AjaxSwing".equals(agent.getUIManager().getWindowInFocusTitle()) && (action = agent.getRequestData().getAction()) != null && action.startsWith("resize:")) {
                TraceMgr.trace((Object)this, (String)"Intercepted resize of About dialog");
                Window aboutWindow = agent.getUIManager().getWindowInFocus();
                aboutWindow.setSize(300, 300);
                if (aboutWindow instanceof JDialog) {
                    JDialog dlg = (JDialog)aboutWindow;
                    dlg.setTitle("Filtered Resize");
                }
                return agent.renderWindows(agent.getRequestData());
            }
        }
        catch (Exception x) {
            TraceMgr.trace((Object)this, (String)"Internal error", (Throwable)x);
        }
        return null;
    }

    public void postProcessRequest(ClientAgent agent, HttpResponseData responseData) {
        TraceMgr.trace((Object)this, (String)"postProcessRequest");
        String title = "About AjaxSwing";
        String message = "AjaxSwing is awesome!";
        try {
            if (title.equals(agent.getUIManager().getWindowInFocusTitle())) {
                String page = responseData.getHtmlPage();
                String ipAddress = (String)agent.getRequestData().getParams().get("custom.ip_address");
                StringBuffer buf = new StringBuffer(page.length() + 100);
                int endOfMessageIndex = page.indexOf(message);
                if (endOfMessageIndex != -1) {
                    buf.append(page.substring(0, endOfMessageIndex));
                    buf.append("<b>Filter IP address: ");
                    buf.append(ipAddress);
                    buf.append("</b>");
                    buf.append(page.substring(endOfMessageIndex + message.length()));
                    responseData.setHtmlPage(buf.toString());
                }
            }
            if (agent.getRequestData().getParams().get("test") != null) {
                TraceMgr.trace((String)("Remove query string by redirecting to " + agent.getInitData().getSubmitURL()));
                responseData.setRedirectURL(agent.getInitData().getSubmitURL());
            }
        }
        catch (Exception x) {
            TraceMgr.trace((Object)this, (String)"Failed to post-process the request", (Throwable)x);
        }
    }

    public boolean preEmulateAction(ClientAgent agent, ActionData data) {
        TraceMgr.trace((Object)this, (String)"preEmulateAction");
        return true;
    }

    public void postEmulateAction(ClientAgent agent, ActionData data) {
        TraceMgr.trace((Object)this, (String)"postEmulateAction");
    }

    public void preRenderWindows(ClientAgent agent, List windows) {
        TraceMgr.trace((Object)this, (String)"preRenderWindow");
    }

    public String postRenderWindows(ClientAgent agent, List windows, String htmlCode) {
        TraceMgr.trace((Object)this, (String)"postRenderWindow");
        return htmlCode;
    }
}

