/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing;

import com.creamtec.ajaxswing.ServletHelper;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.AjaxSwingPropertiesManager;
import com.creamtec.ajaxswing.core.ClientAgentRemote;
import com.creamtec.ajaxswing.servlet.AppDesc;
import com.creamtec.core.TraceMgr;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class TemporaryFileRemover
extends Thread {
    ServletHelper helper;
    protected static Hashtable appDescs = new Hashtable();

    public TemporaryFileRemover(ServletHelper helper, Hashtable appDescs) {
        this.helper = helper;
        TemporaryFileRemover.appDescs = appDescs;
    }

    private boolean allowDelete(File file) {
        for (AppDesc appDesc : appDescs.values()) {
            Iterator agents = appDesc.getAgents();
            while (agents.hasNext()) {
                ClientAgentRemote clientAgentRemote = (ClientAgentRemote)agents.next();
            }
        }
        return false;
    }

    @Override
    public void run() {
        while (this.helper.getRemoveTemporaryFileThread() == Thread.currentThread()) {
            try {
                Enumeration enumer = appDescs.elements();
                while (enumer.hasMoreElements()) {
                    AppDesc appDesc = (AppDesc)enumer.nextElement();
                    String dirPath = appDesc.getTempDirPath();
                    File tempDir = new File(dirPath);
                    if (!tempDir.exists()) continue;
                    File[] files = tempDir.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            if (!TemporaryFileRemover.shouldDeleteTempFile(files[i])) continue;
                            boolean delete = true;
                            Iterator clientAgents = appDesc.getAgents();
                            while (clientAgents.hasNext()) {
                                ClientAgentRemote agent = (ClientAgentRemote)clientAgents.next();
                                Iterator agentFiles = agent.getTempFiles().iterator();
                                while (agentFiles.hasNext() && delete) {
                                    File fl = new File(agentFiles.next().toString());
                                    if (!fl.getCanonicalPath().equals(files[i].getCanonicalPath())) continue;
                                    delete = false;
                                    break;
                                }
                                if (!delete) continue;
                                TraceMgr.trace((Object)this, (String)("Deleting file " + files[i]), (int)6);
                                files[i].delete();
                                try {
                                    int clientId = Integer.parseInt(files[i].getParentFile().getName());
                                    File parent = files[i].getParentFile();
                                    if (!parent.isDirectory() || parent.list().length != 0) continue;
                                    parent.delete();
                                }
                                catch (NumberFormatException clientId) {
                                }
                                catch (Exception ex) {
                                    TraceMgr.trace((Object)this, (String)("Failed to delete temporary file parent folder " + files[i]), (Throwable)ex);
                                }
                            }
                            continue;
                        }
                        catch (Exception x) {
                            TraceMgr.trace((Object)this, (String)("Failed to delete temporary file " + files[i]), (Throwable)x);
                        }
                    }
                }
                Thread.sleep(3600000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {}
        }
    }

    public static boolean shouldDeleteTempFile(File file) {
        AjaxSwingProperties props = AjaxSwingPropertiesManager.getInstance().getAppProperties("default");
        if ("afterTime".equals(props.getProperty("agent.cleanupTempFiles", "session"))) {
            long startFromSize = props.getIntProperty("agent.cleanupTempFiles.smallerThan", 1024);
            if (file.length() < (startFromSize *= 1024L)) {
                return true;
            }
            long timeToDelete = props.getIntProperty("agent.cleanupTempFiles.afterTime", 24);
            timeToDelete = timeToDelete * 1000L * 60L * 60L;
            return new Date().getTime() - file.lastModified() >= timeToDelete;
        }
        return true;
    }
}

