/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing;

import com.creamtec.ajaxswing.ClientAgentImpl;
import com.creamtec.ajaxswing.core.AjaxSwingProperties;
import com.creamtec.ajaxswing.core.AjaxSwingRegistryManager;
import com.creamtec.ajaxswing.core.AjaxSwingSecurityManager;
import com.creamtec.ajaxswing.core.ClientAgentRemote;
import com.creamtec.ajaxswing.core.JVMFactoryRemote;
import com.creamtec.ajaxswing.core.JVMProcessRemote;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Arrays;

public class JVMProcess
extends UnicastRemoteObject
implements JVMProcessRemote,
Unreferenced {
    protected AjaxSwingProperties props = null;
    protected String appName;
    protected int rmiPort;
    protected static JVMProcess instance;

    public JVMProcess(String appName, int rmiPort) throws Exception {
        this.appName = appName;
        this.rmiPort = rmiPort;
        this.registerWithFactory();
    }

    public ClientAgentRemote createClientAgent(String agentName) throws Exception {
        try {
            return new ClientAgentImpl(agentName, this.appName);
        }
        catch (Throwable x) {
            TraceMgr.trace((Object)this, (String)"Failed to create a client agent", (Throwable)x);
            if (x instanceof Error) {
                throw (Error)x;
            }
            throw (Exception)x;
        }
    }

    public void shutdownClientAgent(ClientAgentRemote clientAgent) {
    }

    public void shutdown() {
        TraceMgr.trace((Object)this, (String)("Shutting down JVM, agents = " + ClientAgentImpl.instancesCount), (int)3);
        AjaxSwingSecurityManager.setCheckExit((boolean)false);
        System.exit(0);
    }

    public void ping() {
    }

    public static JVMProcess getInstance() {
        return instance;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("Invalid syntax: JVMProcess -Dajaxswing.home=dir <app_name> <rmi_port> <id>");
            System.exit(1);
        }
        try {
            System.setProperty("java.rmi.dgc.leaseValue", "30000");
            String root = System.getProperty("ajaxswing.home");
            if (root == null) {
                throw new Exception("Initialization property ajaxswing.home is not specified. Use -Dajaxswing.home=dir switch to java command line");
            }
            Utilities.setRootDir((String)root);
            TraceMgr.setLogFileName((String)(args[0] + "_" + args[2] + ".log"));
            TraceMgr.newLine();
            int rmiPort = Integer.parseInt(args[1]);
            TraceMgr.trace((String)("Initiating new JVMProcess on RMI[" + rmiPort + "] -- Params[" + (args == null ? "EMPTY" : Arrays.asList(args)) + "]"), (int)1);
            instance = new JVMProcess(args[0], rmiPort);
        }
        catch (Throwable x) {
            TraceMgr.trace((String)"Failed to initialize", (Throwable)x);
            TraceMgr.trace((String)"Exiting JVM", (int)1);
            System.err.println("Failed to start new JVMProcess | Params[" + (args == null ? "EMPTY" : Arrays.asList(args)) + "]");
            x.printStackTrace();
            System.exit(1);
        }
    }

    protected void registerWithFactory() throws Exception {
        TraceMgr.trace((Object)this, (String)("Registering with JVMProcessFactory on port " + this.rmiPort));
        Registry registry = AjaxSwingRegistryManager.getRegistry((int)this.rmiPort, (int)0);
        JVMFactoryRemote jvmFactory = (JVMFactoryRemote)registry.lookup("creamtec/ajaxswing/JVMFactory");
        jvmFactory.registerJVM(this.appName, (JVMProcessRemote)this);
        TraceMgr.trace((Object)this, (String)"Registered with JVMProcessFactory");
        this.startHealthCheckThread(jvmFactory);
    }

    @Override
    public void unreferenced() {
        TraceMgr.trace((Object)this, (String)"unreferenced, shutting down JVM...");
        this.shutdown();
    }

    protected void startHealthCheckThread(final JVMFactoryRemote jvmFactory) {
        TraceMgr.trace((Object)this, (String)"Starting health check thread...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        jvmFactory.ping();
                        Thread.currentThread();
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException x) {
                    TraceMgr.trace((Object)this, (String)"Ping thread interrupted");
                }
                catch (Exception x) {
                    TraceMgr.trace((Object)this, (String)("Ping of JVMFactory failed, is the JVMFactory process down? " + x.getClass().getName()));
                }
                TraceMgr.trace((Object)this, (String)"Health check failed, exiting", (int)1);
                JVMProcess.this.shutdown();
            }
        }).start();
    }
}

