/*
 * Decompiled with CFR 0.152.
 */
package com.creamtec.ajaxswing;

import com.creamtec.ajaxswing.ServletHelper;
import com.creamtec.ajaxswing.core.ClientAgentFactory;
import com.creamtec.ajaxswing.core.JVMFactory;
import com.creamtec.ajaxswing.servlet.AjaxSwingServlet;
import com.creamtec.core.TraceMgr;
import com.creamtec.core.Utilities;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AjaxSwingRouter
extends HttpServlet {
    protected boolean initSuccessful = false;
    protected ServletHelper helper;
    public static final String PROPS_FILE_NAME = "propsFileName";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.log("init for " + (Object)((Object)this));
        this.initHome(config);
        TraceMgr.trace((Object)((Object)this), (String)"init", (int)3);
        boolean dummy = false;
        try {
            this.helper = ServletHelper.getInstance(this.getServletContext());
            ClientAgentFactory.init((AjaxSwingServlet)this.helper);
        }
        catch (ServletException x) {
            throw x;
        }
        catch (Throwable x) {
            TraceMgr.trace((Object)((Object)this), (String)"Failed to initialize", (Throwable)x);
            throw new ServletException("Failed to initialize AjaxSwing", x);
        }
        TraceMgr.trace((Object)((Object)this), (String)"init complete", (int)3);
        TraceMgr.newLine();
        this.initSuccessful = true;
    }

    private void initHome(ServletConfig config) throws ServletException {
        String ajaxSwingHome = System.getProperty("ajaxswing.home");
        if (ajaxSwingHome == null || ajaxSwingHome.trim().length() == 0) {
            ajaxSwingHome = config.getInitParameter("ajaxswing.home");
        }
        if (ajaxSwingHome == null || ajaxSwingHome.trim().length() == 0) {
            System.out.println("Initialization property ajaxswing.home is not specified. Use -Dajaxswing.home=dir switch to java command line");
            throw new ServletException("Initialization property ajaxswing.home is not specified. Use -Dajaxswing.home=dir switch for java command line or define a servlet parameter for AjaxSwingRouter");
        }
        System.setProperty("ajaxswing.home", ajaxSwingHome);
        Utilities.setRootDir((String)ajaxSwingHome);
        TraceMgr.setLogFileName((String)"ajaxswing.log");
        TraceMgr.trace((String)("Initialized AjaxSwing logger with ajaxswing.home=" + ajaxSwingHome), (int)3);
    }

    public void destroy() {
        this.helper.shutdown();
        super.destroy();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.service(request, response);
        TraceMgr.newLine();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        if (TraceMgr.getCutoffLevel() >= 5) {
            TraceMgr.trace((Object)((Object)this), (String)("doPost, path = " + request.getPathInfo() + ", characterEncoding = " + request.getCharacterEncoding()));
        }
        if (!this.initSuccessful) {
            throw new ServletException("Invalid state, AjaxSwing was not initialized. See log files for details.");
        }
        this.helper.processHttpRequest(request, response);
        if (TraceMgr.getCutoffLevel() >= 3) {
            long processTime = System.currentTimeMillis() - startTime;
            TraceMgr.trace((Object)((Object)this), (String)("doPost completed in " + processTime / 1000L + " s. (" + processTime + " ms.)"), (int)3);
        }
    }

    public String getServletInfo() {
        return "AjaxSwing.AjaxSwingRouter is a service servlet used to forward HTTP request to applications, web-enabled through AjaxSwing";
    }

    public static class InProcessJVMFactory
    extends JVMFactory {
    }
}

